<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'product_name', 'description', 'image', 'quantity', 'price', 'discount', 'discount_in_precent', 'bonuses', 'x_of_bonuses');

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

}